/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import io.github.apace100.origins.util.SerializableDataType;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class SerializableData {
    private HashMap<String, Entry<?>> dataFields = new HashMap();

    public SerializableData add(String name, SerializableDataType<?> type) {
        this.dataFields.put(name, new Entry(type));
        return this;
    }

    public <T> SerializableData add(String name, SerializableDataType<T> type, T defaultValue) {
        this.dataFields.put(name, new Entry<T>(type, defaultValue));
        return this;
    }

    public <T> SerializableData addFunctionedDefault(String name, SerializableDataType<T> type, Function<Instance, T> defaultFunction) {
        this.dataFields.put(name, new Entry<T>(type, defaultFunction));
        return this;
    }

    public void write(PacketBuffer buffer, Instance instance) {
        this.dataFields.forEach((name, entry) -> {
            boolean isPresent;
            boolean bl = isPresent = instance.get((String)name) != null;
            if (((Entry)entry).hasDefault && entry.defaultValue == null) {
                buffer.writeBoolean(isPresent);
            }
            if (isPresent) {
                entry.dataType.send(buffer, instance.get((String)name));
            }
        });
    }

    public Instance read(PacketBuffer buffer) {
        Instance instance = new Instance();
        this.dataFields.forEach((name, entry) -> {
            boolean isPresent = true;
            if (((Entry)entry).hasDefault && entry.defaultValue == null) {
                isPresent = buffer.readBoolean();
            }
            instance.set((String)name, isPresent ? entry.dataType.receive(buffer) : null);
        });
        return instance;
    }

    public Instance read(JsonObject jsonObject) {
        Instance instance = new Instance();
        try {
            this.dataFields.forEach((name, entry) -> {
                if (!jsonObject.has(name)) {
                    if (!entry.hasDefault()) throw new JsonSyntaxException("JSON requires field: " + name);
                    instance.set((String)name, entry.getDefault(instance));
                    return;
                } else {
                    instance.set((String)name, entry.dataType.read(jsonObject.get(name)));
                }
            });
        }
        catch (JsonParseException | ClassCastException e) {
            throw new JsonSyntaxException(e.getClass().getSimpleName() + ": " + e.getMessage(), e);
        }
        return instance;
    }

    private static class Entry<T> {
        public final SerializableDataType<T> dataType;
        public final T defaultValue;
        private final Function<Instance, T> defaultFunction;
        private final boolean hasDefault;
        private final boolean hasDefaultFunction;

        public Entry(SerializableDataType<T> dataType) {
            this.dataType = dataType;
            this.defaultValue = null;
            this.defaultFunction = null;
            this.hasDefault = false;
            this.hasDefaultFunction = false;
        }

        public Entry(SerializableDataType<T> dataType, T defaultValue) {
            this.dataType = dataType;
            this.defaultValue = defaultValue;
            this.defaultFunction = null;
            this.hasDefault = true;
            this.hasDefaultFunction = false;
        }

        public Entry(SerializableDataType<T> dataType, Function<Instance, T> defaultFunction) {
            this.dataType = dataType;
            this.defaultValue = null;
            this.defaultFunction = defaultFunction;
            this.hasDefault = false;
            this.hasDefaultFunction = true;
        }

        public boolean hasDefault() {
            return this.hasDefault || this.hasDefaultFunction;
        }

        public T getDefault(Instance dataInstance) {
            if (this.hasDefaultFunction) {
                return this.defaultFunction.apply(dataInstance);
            }
            if (this.hasDefault) {
                return this.defaultValue;
            }
            throw new IllegalStateException("Tried to access default value of serializable data entry, when no default was provided.");
        }
    }

    public class Instance {
        private HashMap<String, Object> data = new HashMap();

        public boolean isPresent(String name) {
            Entry entry;
            if (SerializableData.this.dataFields.containsKey(name) && (entry = (Entry)SerializableData.this.dataFields.get(name)).hasDefault && entry.defaultValue == null) {
                return this.get(name) != null;
            }
            return true;
        }

        public void set(String name, Object value) {
            this.data.put(name, value);
        }

        public <T> T get(String name) {
            if (!this.data.containsKey(name)) {
                throw new RuntimeException("Tried to get field \"" + name + "\" from data, which did not exist.");
            }
            return (T)this.data.get(name);
        }

        public int getInt(String name) {
            return (Integer)this.get(name);
        }

        public boolean getBoolean(String name) {
            return (Boolean)this.get(name);
        }

        public float getFloat(String name) {
            return ((Float)this.get(name)).floatValue();
        }

        public double getDouble(String name) {
            return (Double)this.get(name);
        }

        @Deprecated
        public String getString(String name) {
            return (String)this.get(name);
        }

        @Deprecated
        public ResourceLocation getId(String name) {
            return (ResourceLocation)this.get(name);
        }

        @Deprecated
        public AttributeModifier getModifier(String name) {
            return (AttributeModifier)this.get(name);
        }
    }
}

